﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderNetworkMap
    {
        public static async Task<IQueryable<ProviderNetwork>> MapProviderNetworks(List<ppms_vaprovidernetwork> ppmsProviderNetworks, string mapRelatedType, PpmsContext context)
        {
            var providerNetworks = new List<ProviderNetwork> { };
            foreach (var ppmsProviderNetwork in ppmsProviderNetworks)
            {
               // var network = NetworkIds.GetNetwork(ppmsProviderNetwork.Id);

                var providerNetwork = new ProviderNetwork
                {
                    ProviderNetworkName = ppmsProviderNetwork.ppms_name,
                    ShortHand = ppmsProviderNetwork.ppms_shorthand,
                    NetworkId = ppmsProviderNetwork.ppms_networknumber.Value
                };


                if (ppmsProviderNetwork.ppms_operatingorganization != null)
                {
                    providerNetwork.OperatingOrganizationName = ppmsProviderNetwork.ppms_operatingorganization.Name;
                }

                if (ppmsProviderNetwork.ppms_VAProviderRelationshipId != null)
                {
                    providerNetwork.VaProviderRelationshipName = ppmsProviderNetwork.ppms_VAProviderRelationshipId.Name;
                }

                //Network Type Switch
                if (ppmsProviderNetwork.ppms_networktype != null)
                    switch (ppmsProviderNetwork.ppms_networktype.Value)
                    {
                        case (int)ppms_vaprovidernetwork_ppms_networktype.ComplementaryServices:
                            providerNetwork.NetworkType = NetworkType.ComplementaryServices;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_networktype.Core:
                            providerNetwork.NetworkType = NetworkType.Core;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_networktype.External:
                            providerNetwork.NetworkType = NetworkType.External;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_networktype.HighPerforming:
                            providerNetwork.NetworkType = NetworkType.HighPerforming;
                            break;
                    }

                //Network Region Switch
                if (ppmsProviderNetwork.ppms_NetworkRegion != null)
                    switch (ppmsProviderNetwork.ppms_NetworkRegion.Value)
                    {
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region1:
                            providerNetwork.NetworkRegion = NetworkRegion.Region1;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region2:
                            providerNetwork.NetworkRegion = NetworkRegion.Region2;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region3:
                            providerNetwork.NetworkRegion = NetworkRegion.Region3;
                            break;
                        case (int)ppms_vaprovidernetwork_ppms_NetworkRegion.Region4:
                            providerNetwork.NetworkRegion = NetworkRegion.Region4;
                            break;
                    }

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=OperatingOrganization"))
                    mapRelatedType = "OperatingOrganization";
                if (mapRelatedType.Contains("?$expand=VaProviderRelationship"))
                    mapRelatedType = "VaProviderRelationship";
                if (mapRelatedType.Contains("?$expand=ProviderServices"))
                    mapRelatedType = "ProviderServices";

                //Map Related Types
                switch (mapRelatedType)
                {
                    case "OperatingOrganization":
                        //Lookup and Map the related Operating Org
                        var OperatingOrg =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderNetwork.ppms_operatingorganization.Id);
                        var operatingOrgList = new List<Account> { OperatingOrg };
                        providerNetwork.OperatingOrganization =
                            await ProviderMap.MapProviders(operatingOrgList, "None", context);
                        break;
                    case "VaProviderRelationship":
                        //Lookup and Map the related Operating Org
                        var VaProviderRelationship =
                            context.ppms_vaproviderrelationshipSet.FirstOrDefault(i => i.Id == ppmsProviderNetwork.ppms_VAProviderRelationshipId.Id);
                        var vaProviderRelationshipList = new List<ppms_vaproviderrelationship> { VaProviderRelationship };
                        providerNetwork.VaProviderRelationship =
                            await VaProviderRelationshipMap.MapVaProviderRelationships(vaProviderRelationshipList, "None", context);
                        break;

                    case "ProviderServices":
                        //Lookup and Map the related Operating Org
                        var ProviderServices =
                            context.ppms_providerserviceSet.Where(i => i.ppms_network.Id == ppmsProviderNetwork.Id);
                        var ppmsProviderServicesList = ProviderServices.ToList();
                        providerNetwork.ProviderServices =
                            await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                        break;

                    default:
                        break;
                }

                providerNetworks.Add(providerNetwork);
            }
            return providerNetworks.AsQueryable();
        }
    }
}